<?php

namespace App\Filament\Resources;

use App\Filament\Resources\BulkMailResource\Pages;
use App\Filament\Resources\BulkMailResource\RelationManagers;
use App\Models\BulkMail;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\RichEditor;

use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Actions\Action;
class BulkMailResource extends Resource
{
    protected static ?string $model = BulkMail::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
      return $form->schema([
         TextInput::make('subject')->required(),
         RichEditor::make('body')->label('E-Posta İçeriği')->required(),

         FileUpload::make('attachment_path')
         ->label('Görsel Dosyalar')
->multiple()
->directory('attachments')
->preserveFilenames()
             ->directory('attachments'),

             FileUpload::make('excel_file_path')
                 ->label('Excel Dosyası (.xlsx)')
                 ->directory('excels')
                 ->acceptedFileTypes(['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet']) // MIME type
                 ->required(),


         TextInput::make('email_column')
             ->label('E-Posta Sütunu (örnek: A veya email)')
             ->required(),
     ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('subject')->label('Konu'),
                Tables\Columns\TextColumn::make('email_column')->label('E-Posta Sütunu'),
                Tables\Columns\TextColumn::make('created_at')->dateTime('d.m.Y H:i'),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),

                Action::make('sendEmails')
                    ->label('Gönder')
                    ->icon('heroicon-o-paper-airplane')
                    ->color('success')
                    ->requiresConfirmation()
                    ->action(function ($record) {
                        app(\App\Http\Controllers\BulkMailSendController::class)->send($record);

                        \Filament\Notifications\Notification::make()
                            ->title('Toplu mail gönderimi başlatıldı.')
                            ->success()
                            ->send();
                    }),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBulkMails::route('/'),
            'create' => Pages\CreateBulkMail::route('/create'),
            'edit' => Pages\EditBulkMail::route('/{record}/edit'),
        ];
    }
}
