<?php

namespace App\Filament\Resources\BulkMailResource\Pages;

use App\Filament\Resources\BulkMailResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Filament\Tables\Actions\Action;
use Filament\Notifications\Notification;
use App\Http\Controllers\BulkMailSendController;
class ListBulkMails extends ListRecords
{
    protected static string $resource = BulkMailResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }

      protected function getTableActions(): array
  {
      return [
          Action::make('sendEmails')
              ->label('Gönder')
              ->icon('heroicon-o-paper-airplane')
              ->color('success')
              ->requiresConfirmation()
              ->action(function ($record) {
                  app(BulkMailSendController::class)->send($record);

                  Notification::make()
                      ->title('Toplu mail gönderimi başlatıldı.')
                      ->success()
                      ->send();
              }),
      ];
  }
}
