<?php

namespace App\Filament\Resources;

use App\Filament\Resources\SiteSettingResource\Pages;
use App\Models\SiteSetting;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables\Table;

class SiteSettingResource extends Resource
{
    protected static ?string $model = SiteSetting::class;

    protected static ?string $navigationIcon = 'heroicon-o-cog-6-tooth';
    protected static ?string $navigationLabel = 'Site Ayarları';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\TextInput::make('site_title'),
            Forms\Components\TextInput::make('meta_keywords'),
            Forms\Components\Textarea::make('meta_description'),
            Forms\Components\FileUpload::make('logo')->image()->directory('settings'),
            Forms\Components\FileUpload::make('favicon')->image()->directory('settings'),
            Forms\Components\TextInput::make('email'),
            Forms\Components\TextInput::make('phone'),
            Forms\Components\Textarea::make('address'),
            Forms\Components\TextInput::make('facebook'),
            Forms\Components\TextInput::make('instagram'),
            Forms\Components\TextInput::make('twitter'),

            Forms\Components\Select::make('homepage_id')
                ->label('Ana Sayfa')
                ->relationship('homepage', 'title')
                ->searchable()
                ->nullable()
                ->helperText('Sitede gösterilecek varsayılan ana sayfa.'),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([]); // hiç kullanılmayacak
    }

    public static function getPages(): array
    {
        return [
          'index' => Pages\ListSiteSettings::route('/'),

            'edit' => Pages\EditSiteSetting::route('/{record}/edit'),
        ];
    }

    public static function getNavigationUrl(): string
    {
        return static::getUrl('edit', ['record' => 1]);
    }
}
