<?php

namespace App\Http\Controllers;

use App\Models\BulkMail;
use App\Jobs\SendBulkMailJob;
use Illuminate\Support\Facades\Log;
use PhpOffice\PhpSpreadsheet\IOFactory;

class BulkMailSendController extends Controller
{
    public function send(BulkMail $record)
    {
        $excelPath = storage_path("app/public/{$record->excel_file_path}");

        if (!file_exists($excelPath)) {
            Log::error("Excel dosyası bulunamadı: {$excelPath}");
            return response()->json(['status' => 'error', 'message' => 'Dosya bulunamadı.'], 404);
        }

        try {
            $spreadsheet = IOFactory::load($excelPath);
            $sheet = $spreadsheet->getActiveSheet();
            $rows = $sheet->toArray();
        } catch (\Exception $e) {
            Log::error("Excel dosyası okunamadı: {$e->getMessage()}");
            return response()->json(['status' => 'error', 'message' => 'Excel okunamadı.'], 500);
        }

        $colIndex = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($record->email_column) - 1;

        foreach ($rows as $index => $row) {
            if ($index === 0 || !is_array($row) || !isset($row[$colIndex])) {
                Log::warning("Satır atlandı (satır {$index})");
                continue;
            }

            $email = trim($row[$colIndex]);

            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                Log::warning("Geçersiz e-posta atlandı: {$email} (satır {$index})");
                continue;
            }

            dispatch(new SendBulkMailJob($record, $email, $index));
        }

        return response()->json(['status' => 'queued']);
    }
}

 ?>
