<?php


namespace App\Http\Controllers;

use App\Models\Menu;
use App\Models\Page;
use Illuminate\Support\Facades\Blade;
use App\Models\SiteSetting;
use App\Models\Project;
use Illuminate\Http\Request;
use App\Models\ProjectApplication;

class PageController extends Controller
{


  public function home()
  {
      $setting = SiteSetting::with('homepage')->first();
      $page = $setting?->homepage;

      if (!$page) {
          //return view('welcome');
      }
      $kurulusYili = 2000;
      $yilFarki = date('Y') - $kurulusYili;
      $compiledContent = Blade::render($page->builder);

      // News verilerini al (son 10 haber örneği)
      $news = \App\Models\News::latest()->take(10)->get();

      return view('pages.default', [
          'page' => $page,
          'builderHtml' => $compiledContent,
          'news' => $news,
          'yilFarki' => $yilFarki,

      ]);
  }

  public function project($slug)
   {
       $project = Project::where('slug', $slug)->firstOrFail();

       // Eğer dış link varsa, yönlendir
       if ($project->external_url) {
           return redirect()->away($project->external_url);
       }

       return view('projects.detail', compact('project'));
   }

  private function buildBreadcrumb($menu)
{
    $breadcrumb = [];

    while ($menu) {
        $breadcrumb[] = [
            'label' => $menu->label,
            'url' => $menu->url,
        ];
        $menu = $menu->parent;
    }

    // Ters çeviriyoruz ki en üst parent başta olsun
    return array_reverse($breadcrumb);
}
public function show($slug = null)
{
    $slug = ltrim($slug, '/');

    $menu = Menu::where('url', $slug)->first();
    $breadcrumb = [];
    $page = null;
    $kurulusYili = 2000;
    $yilFarki = date('Y') - $kurulusYili;

    if ($menu) {
        if ($menu->type === 'page' && $menu->page_id) {
            $page = Page::findOrFail($menu->page_id);
            $breadcrumb = $this->buildBreadcrumb($menu);


              $compiledContent = Blade::render($page->builder);

            $news = \App\Models\News::latest()->take(10)->get();



            return view('pages.default', [
                'page' => $page,
                'builderHtml' => $compiledContent,
                'breadcrumb' => $breadcrumb,
                'news' => $news,
                'yilFarki' => $yilFarki,

            ]);

        } elseif ($menu->type === 'news') {
            $news = \App\Models\News::latest()->paginate(10);
            return view('pages.news-index', [
                'news' => $news,
                'menu' => $menu,
                'breadcrumb' => $this->buildBreadcrumb($menu),
            ]);
        }

        // Diğer type durumları (örneğin 'custom') burada kontrol edilebilir
    }

    // Menü bulunamadıysa ya da URL eşleşmediyse fallback: page slug eşleştir
    $page = Page::where('slug', $slug)->firstOrFail();

    $compiledContent = Blade::render($page->builder);


    return view('pages.default', [
        'page' => $page,
        'builderHtml' => $compiledContent,
        'breadcrumb' => $breadcrumb,
        'yilFarki' => $yilFarki,

    ]);
}


public function detail($slug)
{
    $news = \App\Models\News::where('slug', $slug)->firstOrFail();
    // Okunma sayısını arttır
$news->increment('views');

$newsd = \App\Models\News::latest()->take(10)->get();

    return view('pages.news-detail', compact('news','newsd'));
}


public function apply(Request $request, $slug)
{
    $project = Project::where('slug', $slug)->firstOrFail();

    $formData = [];

    foreach ($request->form as $key => $value) {
        if ($value instanceof \Illuminate\Http\UploadedFile) {
            $path = $value->store('applications', 'public');
            $formData[$key] = $path;
        } else {
            $formData[$key] = $value;
        }
    }

    ProjectApplication::create([
        'project_id' => $project->id,
        'form_data' => $formData,
    ]);

    return response()->json([
    'success' => true,
    'message' => 'Başvurunuz başarıyla alınmıştır.',
]);
}



}





?>
