<?php
namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Str;

class SendBulkMailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $record;
    public $email;
    public $index;

    public function __construct($record, $email, $index)
    {
        $this->record = $record;
        $this->email = $email;
        $this->index = $index;
    }

    public function handle()
    {
        try {
            Mail::send([], [], function ($message) {
                $message->to($this->email)
                        ->subject($this->record->subject)
                        ->html($this->record->body);

                $baseName = Str::slug($this->record->subject);

                $attachments = is_array($this->record->attachment_path)
                    ? $this->record->attachment_path
                    : (json_decode($this->record->attachment_path, true) ?? [$this->record->attachment_path]);

                foreach ($attachments as $i => $path) {
                    $fullPath = storage_path("app/public/" . ltrim($path, '/'));

                    if (!file_exists($fullPath)) {
                        Log::warning("Ek dosya bulunamadı: {$fullPath}");
                        continue;
                    }

                    $extension = pathinfo($fullPath, PATHINFO_EXTENSION);
                    $customName = $baseName . (count($attachments) > 1 ? '-' . ($i + 1) : '') . '.' . $extension;

                    $message->attach($fullPath, [
                        'as' => $customName,
                        'mime' => mime_content_type($fullPath),
                    ]);

                    Log::info("Ek dosya eklendi: {$customName} ({$fullPath})");
                }
            });

            Log::info("Mail gönderildi: {$this->email}");
        } catch (\Exception $e) {
            Log::error("Mail gönderilemedi: {$this->email} - Hata: " . $e->getMessage());
        }
    }
}
