<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;
class Menu extends Model implements Sortable
{
    use HasFactory, SortableTrait;

    protected $fillable = [
        'label',
        'url',
        'page_id',
        'parent_id',
        'sort',
        'type',
        'images',

    ];

    public function parent()
    {
        return $this->belongsTo(Menu::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(Menu::class, 'parent_id');
    }

    public function page()
    {
        return $this->belongsTo(Page::class);
    }
    public function getIndentedLabelAttribute()
    {
        $prefix = '';

        $parent = $this->parent;
        while ($parent) {
            $prefix .= '— ';
            $parent = $parent->parent;
        }

        return $prefix . $this->label;
    }


    public function buildSortQuery()
{
    return static::query()->where('parent_id', $this->parent_id);
}

}
