<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Spatie\Image\Image;
use Spatie\LaravelImageOptimizer\Facades\ImageOptimizer;

class News extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'slug',
        'content',
        'image',
        'status',
        'gallery',
        'views',

    ];

    protected static function booted()
    {
        static::saving(function ($news) {
            if (request()->hasFile('image')) {
                $file = request()->file('image');
                $filename = $file->hashName();

                // Orijinal kaydet
                $path = $file->storeAs('news', $filename, 'public');
                $news->image = $path;

                // 789x400 versiyon
                $path789 = storage_path('app/public/news/789x400/' . $filename);
                Image::load($file->getRealPath())
                    ->fit(789, 400)
                    ->save($path789);

                // 384x271 versiyon
                $path384 = storage_path('app/public/news/384x271/' . $filename);
                Image::load($file->getRealPath())
                    ->fit(384, 271)
                    ->save($path384);

                // Optimize (opsiyonel)
                ImageOptimizer::optimize($path789);
                ImageOptimizer::optimize($path384);
            }
        });
    }


}
