<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SiteSetting extends Model
{
    use HasFactory;
    protected $fillable = [
      'site_title',
      'meta_keywords',
      'meta_description',
      'logo',
      'favicon',
      'email',
      'phone',
      'address',
      'facebook',
      'instagram',
      'twitter',
      'homepage_id', // ✅ eklendi

  ];

  public function homepage()
{
    return $this->belongsTo(\App\Models\Page::class, 'homepage_id');
}
}
