<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('menus', function (Blueprint $table) {
      $table->id();
      $table->string('label');
      $table->string('url')->nullable();
      $table->integer('sort')->default(0);
      $table->foreignId('parent_id')->nullable()->constrained('menus')->onDelete('cascade');
      $table->timestamps();
  });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('menus');
    }
};
