<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;


return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('site_settings', function (Blueprint $table) {
              $table->id();
              $table->string('site_title')->nullable();
              $table->string('meta_keywords')->nullable();
              $table->string('meta_description')->nullable();
              $table->string('logo')->nullable();
              $table->string('favicon')->nullable();
              $table->string('email')->nullable();
              $table->string('phone')->nullable();
              $table->string('address')->nullable();
              $table->string('facebook')->nullable();
              $table->string('instagram')->nullable();
              $table->string('twitter')->nullable();
              $table->timestamps();
          });

          // DEMO VERİ EKLE
          DB::table('site_settings')->insert([
              'site_title' => 'TABİD - Teknoloji Ar-Ge Bilim İnovasyon Derneği',
              'meta_keywords' => 'tabid, teknoloji, bilim, ar-ge, inovasyon',
              'meta_description' => 'TABİD, Türkiye’nin teknoloji ve bilimde çağdaşlaşmasına katkı sunar.',
              'email' => 'iletisim@tabid.org.tr',
              'phone' => '+90 312 123 45 67',
              'address' => 'Ankara, Türkiye',
              'created_at' => now(),
              'updated_at' => now(),
          ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('site_settings');
    }
};
