<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('projects', function (Blueprint $table) {
       $table->id();
       $table->string('title');
       $table->string('breadcrumb');
       $table->string('slug')->unique();
       $table->text('content');
       $table->string('external_url')->nullable(); // dış link opsiyonu
       $table->json('form_config')->nullable(); // başvuru form alanları JSON saklanacak
       $table->timestamps();
   });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projects');
    }
};
