import { Selector, State, Editor } from 'grapesjs';
import { ReactElement, JSX } from 'react';
import { PortalContainerResult } from './utils/react';
export type SelectorsState = {
    /**
     * Array of current selectors.
     */
    selectors: Selector[];
    /**
     * Array of available states.
     */
    states: State[];
    /**
     * Current selected state.
     */
    selectedState: string;
    /**
     * Selector strings of currently selected targets.
     */
    targets: string[];
    /**
     * Add new selector to selected targets.
     */
    addSelector: (...args: Parameters<Editor['Selectors']['addSelected']>) => void;
    /**
     * Remove selector from selected targets.
     */
    removeSelector: (...args: Parameters<Editor['Selectors']['removeSelected']>) => void;
    /**
     * Update current state.
     */
    setState: (...args: Parameters<Editor['Selectors']['setState']>) => void;
    /**
     * Default Selectors container.
     */
    Container: PortalContainerResult;
};
export type SelectorsResultProps = SelectorsState;
export interface SelectorsProviderProps {
    children: (props: SelectorsResultProps) => ReactElement<any>;
}
declare const _default: (props: SelectorsProviderProps) => JSX.Element;
export default _default;
