/// <reference types="react" />
import { InputFieldProps } from '../InputField';
import { InputFieldWrapperProps } from '../InputField/InputFieldWrapper';
import { Option } from '../SelectField';
export interface AutocompleteFieldProps {
    options: Option[];
    onChange(option: Option): void;
    onBlur?(): void;
    value?: Option;
    name?: string;
    placeholder?: string;
    border?: InputFieldWrapperProps['border'];
    size?: InputFieldProps['size'];
    className?: string;
    allowNew?: string | ((s: string) => string);
    autoFocus?: boolean;
    open?: boolean;
    hideCaret?: boolean;
    label?: React.ReactNode;
}
export default function AutocompleteField({ className, options, value, name, label, border, hideCaret, size, autoFocus, open, allowNew, onChange, onBlur, placeholder }: AutocompleteFieldProps): import("react/jsx-runtime").JSX.Element;
