/// <reference types="react" />
import { EditorProps } from '@monaco-editor/react';
import { InputSize } from '../InputField';
export interface CodeFieldProps extends Omit<React.TextareaHTMLAttributes<HTMLTextAreaElement>, 'onChange'> {
    language: string;
    onChange?: EditorProps['onChange'];
    clean?: boolean;
    isDarkTheme?: boolean;
    containerClassName?: string;
    minHeight?: string;
    padding?: number;
    size?: `${InputSize}`;
    label?: React.ReactNode;
    description?: React.ReactNode;
    name?: string;
    row?: boolean;
    required?: boolean;
    disabled?: boolean;
    onMount?: EditorProps['onMount'];
    monacoOptions?: Partial<EditorProps['options']>;
}
export declare const formatCode: (editor: editor.IStandaloneCodeEditor) => void;
/**
 * Editor props: https://github.com/suren-atoyan/monaco-react#props
 * Editor playground: https://monaco-react.surenatoyan.com/
 *
 * List of custom themes: https://github.com/brijeshb42/monaco-themes/tree/master/themes
 * How to define themes: https://codesandbox.io/s/monaco-theme-oijvt
 */
export default function CodeField(props: CodeFieldProps): import("react/jsx-runtime").JSX.Element;
