import type { Editor } from 'grapesjs';
import { CanvasSpotWrapperProps } from '../Grapesjs/CanvasSpotWrapper';
import { getComponentColorClasses } from '../theme';
type ComponentDragEventProps = any;
type GuideMatched = ComponentDragEventProps['guidesMatched'][number];
/**
 * This component is used to render the drag spot.
 * - CanvasComponentHighlight is used to highlight the dragged and matched component.
 * - CanvasOriginMatchedDistance is used to show the distance between the dragged and matched component.
 */
export default function CanvasSpotDrag({ spot, className }: CanvasSpotWrapperProps): import("react/jsx-runtime").JSX.Element;
/**
 * This component is used to render the distance between the origin and matched components.
 */
export declare function CanvasOriginMatchedDistance(props: {
    editor: Editor;
    originMatchedDistance: GuideMatched;
    className: string;
    componentColorClasses: ReturnType<typeof getComponentColorClasses>;
}): import("react/jsx-runtime").JSX.Element;
export {};
