/// <reference types="react" />
import { GlobalStyleRecord } from '../../types';
import { ButtonGroupFieldProps } from '../ButtonGroupField';
import { InputFieldProps } from '../InputField';
import { NumberFieldProps } from '../NumberField';
import { SelectFieldProps } from '../SelectField';
import { SelectFontFieldProps } from '../SelectFontField';
export interface GlobalStyleRecordFieldProps extends React.HTMLProps<HTMLDivElement> {
    record: GlobalStyleRecord;
}
export interface GlobalStyleFieldOptions {
    id: string | number;
    t: (key: string) => string;
}
export declare const getInputProps: (record: GlobalStyleRecord, opts: GlobalStyleFieldOptions) => InputFieldProps;
export declare const getNumberProps: (record: GlobalStyleRecord, opts: GlobalStyleFieldOptions) => NumberFieldProps;
export declare const getSelectProps: (record: GlobalStyleRecord, opts: GlobalStyleFieldOptions) => SelectFieldProps;
export declare const getSelectFontProps: (record: GlobalStyleRecord, opts: GlobalStyleFieldOptions) => Omit<SelectFontFieldProps, 'label'> & {
    label: string;
};
export declare const getButtonGroupProps: (record: GlobalStyleRecord, opts: GlobalStyleFieldOptions) => ButtonGroupFieldProps;
declare const GlobalStyleField: import("react").FunctionComponent<GlobalStyleRecordFieldProps>;
export default GlobalStyleField;
