/// <reference types="react" />
import { LabelFieldProps } from '../LabelField';
import { InputSize } from '../public/types/StudioInputFieldSchema';
export { InputSize } from '../public/types/StudioInputFieldSchema';
export type { InputSizeType } from '../public/types/StudioInputFieldSchema';
export interface InputFieldProps {
    className?: string;
    style?: React.CSSProperties;
    name?: string;
    value: string;
    placeholder?: string;
    required?: boolean;
    readOnly?: boolean;
    disabled?: boolean;
    row?: boolean;
    label?: React.ReactNode;
    afterLabel?: React.ReactNode;
    description?: React.ReactNode;
    beforeInput?: React.ReactNode;
    afterInput?: React.ReactNode;
    size?: `${InputSize}`;
    type?: string;
    tip?: LabelFieldProps['tip'];
    hasClear?: (props: InputFieldProps) => boolean;
    onInput?(value: string): void;
    onChange?(value: string, partial?: boolean): void;
    onBlur?(): void;
}
interface InputFieldPropsNoValue extends Omit<InputFieldProps, 'value'> {
}
export declare const getValue: (value: string) => string;
export declare const getInputClassName: (props?: Partial<InputFieldPropsNoValue>) => string;
export declare const getInputContainerClassName: ({ size }?: Partial<InputFieldPropsNoValue>) => string;
export declare const getRootProps: ({ className, style, row }: Omit<InputFieldPropsNoValue, 'size' | 'onBlur' | 'onInput'>) => {
    className: string;
    style: import("react").CSSProperties | undefined;
};
export declare const LabelFieldContainer: (props: Omit<InputFieldPropsNoValue, "onBlur" | "onInput"> & {
    as?: string | undefined;
}) => import("react/jsx-runtime").JSX.Element | null;
declare const _default: import("react").ForwardRefExoticComponent<InputFieldProps & import("react").RefAttributes<HTMLDivElement>>;
export default _default;
