import type PopperJS from '@popperjs/core';
import { ElementType } from 'react';
import { CardProps } from '../Card';
import { LabelFieldProps } from '../LabelField';
export type OptionId = any;
export interface Option {
    id: OptionId;
    label: string;
    className?: string;
    content?: React.ReactNode;
}
export interface SelectOption extends Option {
}
export type SearchOptions = {
    empty: React.ReactNode;
    value?: string;
    onChange?: (v: string) => void;
};
export interface SelectFieldProps extends Omit<React.HTMLProps<HTMLSelectElement>, 'label' | 'size'> {
    classNameContainer?: string;
    name?: string;
    handlerSelected?(o: Option): React.ReactNode;
    handlerOption?(o: Option): React.ReactNode;
    label?: React.ReactNode;
    afterLabel?: React.ReactNode;
    labelAs?: ElementType;
    options: Option[];
    emptyState?: string;
    includeEmpty?: boolean;
    required?: boolean;
    search?: boolean | SearchOptions;
    fixed?: boolean;
    open?: boolean;
    size?: CardProps['size'];
    border?: CardProps['border'];
    value: OptionId;
    caret?: string;
    width?: string;
    pos?: 'top' | 'right' | 'bottom' | 'left';
    autoFocus?: boolean;
    tip?: LabelFieldProps['tip'];
    onChange(value: OptionId): void;
    onBlur?(): void;
    onFocus?(): void;
}
export declare const optionsClassName: string;
export declare const selectPopperOptions: Partial<PopperJS.Options>;
export declare function SelectFieldItem(props: {
    option: Option;
    active?: boolean;
    selected?: Option;
    isSelected?: () => boolean;
}): import("react/jsx-runtime").JSX.Element;
export default function SelectField(props: SelectFieldProps): import("react/jsx-runtime").JSX.Element;
