/// <reference types="react" />
export interface StackFieldProps<T> {
    className?: string;
    items: T[];
    selected: T | null;
    renderItem: (item: T) => React.ReactNode;
    select?: (item: T | null) => void;
    add?: () => void;
    remove?: (item: T) => void;
    move?: (item: T, index: number) => void;
    reset?: (items: T[]) => void;
    previewStyle?: (items: T) => Record<string, string>;
    getItemId?: (item: T) => string;
    label?: React.ReactNode;
    children?: React.ReactNode;
    title?: React.ReactNode;
    titleAdd?: React.ReactNode;
    emptyState?: React.ReactNode;
}
export default function StackField<T = any>({ className, items, selected, children, title, titleAdd, label, emptyState, select, add, move, remove, renderItem, previewStyle, getItemId }: StackFieldProps<T>): import("react/jsx-runtime").JSX.Element;
