/// <reference types="react" />
import { TraitsResultProps } from '@grapesjs/react';
import type { Editor, Trait } from 'grapesjs';
import { CodeFieldProps } from '../CodeField';
export declare const getCommonProps: (trait: Trait) => {
    size: "s";
    tip: any;
};
export declare const getInputProps: (trait: Trait, editor?: Editor) => {
    type: string;
    value: any;
    label: string | false;
    placeholder: any;
    onChange: (value: string, partial: boolean) => void;
    size: "s";
    tip: any;
};
export declare const getSelectProps: (trait: Trait) => {
    options: ({
        id: string;
        label: string;
        title?: undefined;
        icon?: undefined;
    } | {
        id: any;
        title: any;
        icon: any;
        label: any;
    })[];
    onChange: (value: string) => void;
    type: string;
    value: any;
    label: string | false;
    placeholder: any;
    size: "s";
    tip: any;
};
export declare const getNumberProps: (trait: any) => {
    min: any;
    max: any;
    step: any;
    units: any;
    onChange: (value: string, partial: boolean) => void;
    type: string;
    value: any;
    label: string | false;
    placeholder: any;
    size: "s";
    tip: any;
};
export declare const getButtonProps: (trait: Trait) => {
    children: string;
    onClick: () => void;
    full: boolean;
};
export declare const getCheckboxProps: (trait: Trait) => {
    value: boolean;
    label: string;
    onChange: (value: boolean) => void;
    size: "s";
    tip: any;
};
export declare const getCodeProps: (trait: Trait) => CodeFieldProps;
export declare const getFileProps: (trait: Trait, editor?: Editor) => any;
declare function TraitManager({ traits, className }: TraitsResultProps & React.HTMLProps<HTMLDivElement>): import("react/jsx-runtime").JSX.Element;
declare const _default: typeof TraitManager & {
    displayName: string;
};
export default _default;
