/// <reference types="react" />
import type { StudioIconProps } from './StudioIcon';
import type { CommonStudioLayoutConfigProps, WithEditorEvents, WithEditorState } from './types';
import type { StudioLayoutButtonGroupFieldConfig } from './types/StudioButtonGroupFieldSchema';
export interface StudioButtonGroupFieldOptionProps {
    id: string;
    icon?: StudioIconProps['icon'];
    label?: React.ReactNode;
    title?: React.ReactNode;
}
export interface StudioLayoutButtonGroupFieldConfigProps extends CommonStudioLayoutConfigProps<StudioButtonGroupFieldProps, StudioLayoutButtonGroupFieldConfig> {
}
export interface StudioButtonGroupFieldProps extends Omit<StudioLayoutButtonGroupFieldConfig, 'type' | 'label' | 'style' | 'options' | 'onChange' | 'editorEvents'>, WithEditorEvents<StudioButtonGroupFieldState> {
    label?: React.ReactNode;
    style?: React.CSSProperties;
    options: StudioButtonGroupFieldOptionProps[];
    onChange(props: {
        value: string;
    } & WithEditorState<StudioButtonGroupFieldState>): void;
}
export interface StudioButtonGroupFieldState extends Partial<Pick<StudioButtonGroupFieldProps, 'className' | 'label' | 'name' | 'value' | 'options' | 'size' | 'required' | 'disabled'>> {
}
export declare const StudioButtonGroupField: import("react").NamedExoticComponent<StudioButtonGroupFieldProps>;
export default StudioButtonGroupField;
