/// <reference types="react" />
import type { Editor } from 'grapesjs';
import type { StudioLayoutCustomConfig } from './types/StudioCustomSchema';
import type { CommonStudioLayoutConfigProps } from './types';
interface CustomLayoutRenderFnProps {
    editor?: Editor;
    addEl: (el: HTMLElement) => void;
    removeEl: (el: HTMLElement) => void;
}
type CustomLayoutRenderFn = (props: CustomLayoutRenderFnProps) => undefined | string | HTMLElement | (() => void);
export interface StudioLayoutCustomConfigProps extends CommonStudioLayoutConfigProps<StudioCustomLayoutProps, StudioLayoutCustomConfig> {
}
export interface StudioCustomLayoutProps extends Omit<StudioLayoutCustomConfig, 'style' | 'type' | 'component' | 'render'> {
    component?: React.FC<{
        editor: Editor;
    }>;
    style?: React.CSSProperties;
    render?: CustomLayoutRenderFn;
}
declare const _default: import("react").MemoExoticComponent<import("react").ForwardRefExoticComponent<Omit<StudioCustomLayoutProps & import("react").RefAttributes<HTMLDivElement>, "ref"> & import("react").RefAttributes<HTMLDivElement>>>;
export default _default;
