/// <reference types="react" />
import type { Component } from 'grapesjs';
import { ConditionGroup } from '../DataConditionPicker/types';
import type { CommonStudioLayoutConfigProps, CommonStudioLayoutProps } from './types';
import { StudioLayoutDataConditionPickerConfig } from './types/StudioDataConditionPickerSchema';
export interface DataConditionResolverProps {
    condition: ConditionGroup;
}
export interface StudioLayoutDataConditionPickerConfigProps extends CommonStudioLayoutConfigProps<StudioDataConditionPickerProps, StudioLayoutDataConditionPickerConfig> {
}
export interface StudioDataConditionPickerProps extends Omit<CommonStudioLayoutProps<StudioLayoutDataConditionPickerConfig>, 'component' | 'onConfirm'> {
    component: Component;
    onConfirm?: (props: {
        value: DataConditionResolverProps;
    }) => void;
}
export declare const StudioDataConditionPicker: import("react").FunctionComponent<StudioDataConditionPickerProps>;
export default StudioDataConditionPicker;
