/// <reference types="react" />
import type { CommonStudioLayoutConfigProps, WithEditorEvents, WithEditorState } from './types';
import type { StudioLayoutSelectFieldConfig } from './types/StudioSelectFieldSchema';
export interface StudioSelectFieldOptionProps {
    id: string;
    label: string;
    content?: React.ReactNode;
}
export interface StudioLayoutSelectFieldConfigProps extends CommonStudioLayoutConfigProps<StudioSelectFieldProps, StudioLayoutSelectFieldConfig> {
}
export interface StudioSelectFieldProps extends Omit<StudioLayoutSelectFieldConfig, 'type' | 'label' | 'style' | 'options' | 'onChange' | 'editorEvents'>, WithEditorEvents<StudioSelectFieldState> {
    label?: React.ReactNode;
    style?: React.CSSProperties;
    options: StudioSelectFieldOptionProps[];
    onChange(props: {
        value: string;
    } & WithEditorState<StudioSelectFieldState>): void;
}
export interface StudioSelectFieldState extends Partial<Pick<StudioSelectFieldProps, 'className' | 'style' | 'label' | 'name' | 'value' | 'options' | 'size' | 'emptyState' | 'required' | 'disabled'>> {
}
export declare const StudioSelectField: import("react").NamedExoticComponent<StudioSelectFieldProps>;
export default StudioSelectField;
