/// <reference types="react" />
import type { CommonStudioLayoutConfigProps, WithEditorEvents, WithEditorState } from './types';
import type { StudioLayoutSelectFontFieldConfig } from './types/StudioSelectFontFieldSchema';
export interface StudioSelectFontFieldOptionProps {
    id: string;
    label: string;
    content?: React.ReactNode;
}
export interface StudioLayoutSelectFontFieldConfigProps extends CommonStudioLayoutConfigProps<StudioSelectFontFieldProps, StudioLayoutSelectFontFieldConfig> {
}
export interface StudioSelectFontFieldProps extends Omit<StudioLayoutSelectFontFieldConfig, 'type' | 'label' | 'style' | 'options' | 'onChange' | 'editorEvents'>, WithEditorEvents<StudioSelectFontFieldState> {
    label?: React.ReactNode;
    style?: React.CSSProperties;
    onChange(props: {
        value: string;
    } & WithEditorState<StudioSelectFontFieldState>): void;
}
export interface StudioSelectFontFieldState extends Partial<Pick<StudioSelectFontFieldProps, 'className' | 'style' | 'label' | 'name' | 'value' | 'size' | 'emptyState' | 'required' | 'disabled'>> {
}
export declare const StudioSelectFontField: import("react").NamedExoticComponent<StudioSelectFontFieldProps>;
export default StudioSelectFontField;
