/// <reference types="react" />
import { TabOption, TabsProps } from '../Tabs';
import type { StudioLayoutTabsConfig } from './types/StudioTabsSchema';
import type { CommonStudioLayoutConfigProps, WithEditorEvents, WithEditorState, StudioLayoutWithChildrenConfigProps } from './types';
type TabsStringProps = TabsProps<string>;
export interface StudioTabProps extends StudioLayoutWithChildrenConfigProps, Pick<TabOption, 'id'> {
    label: string;
}
export interface StudioLayoutTabsConfigProps extends CommonStudioLayoutConfigProps<StudioTabsProps, StudioLayoutTabsConfig> {
}
export interface StudioTabsProps extends Omit<StudioLayoutTabsConfig, 'type' | 'variant' | 'value' | 'tabs' | 'onChange' | 'editorEvents'>, WithEditorEvents<StudioTabsState> {
    variant?: TabsStringProps['variant'];
    value?: TabsStringProps['value'];
    tabs: StudioTabProps[];
    onChange?: (props: {
        value: string;
    } & WithEditorState<StudioTabsState>) => void;
}
export interface StudioTabsState extends Partial<Pick<StudioTabsProps, 'tabs' | 'variant' | 'value' | 'style' | 'className'>> {
}
export declare const StudioTabs: import("react").FunctionComponent<StudioTabsProps>;
export default StudioTabs;
