import type { Editor, ObjectAny } from 'grapesjs';
import type { CSSProperties } from 'react';
import { StudioLayoutButtonConfigProps } from './StudioButton';
import { StudioLayoutButtonGroupFieldConfigProps } from './StudioButtonGroupField';
import { StudioLayoutCanvasConfigProps } from './StudioCanvas';
import { StudioLayoutCanvasSidebarTopConfigProps } from './StudioCanvasSidebarTop';
import { StudioLayoutCodeFieldConfigProps } from './StudioCodeField';
import { StudioLayoutColumnConfigProps } from './StudioColumn';
import { StudioCustomLayoutProps, StudioLayoutCustomConfigProps } from './StudioCustomLayout';
import { StudioLayoutDataCollectionPickerConfigProps } from './StudioDataCollectionPicker';
import { StudioLayoutDataConditionPickerConfigProps } from './StudioDataConditionPicker';
import { StudioLayoutDataPathFieldConfigProps } from './StudioDataPathField';
import { StudioLayoutDataVariablePickerConfigProps } from './StudioDataVariablePicker';
import { StudioLayoutDevicesConfigProps } from './StudioDevices';
import { StudioLayoutInputFieldConfigProps } from './StudioInputField';
import { StudioLayoutPanelAssetsConfigProps } from './StudioPanelAssets';
import { StudioLayoutPanelBlocksConfigProps } from './StudioPanelBlocks';
import { StudioLayoutPanelGlobalStylesConfigProps } from './StudioPanelGlobalStyles';
import { StudioLayoutPanelLayersConfigProps } from './StudioPanelLayers';
import { StudioLayoutPanelPageSettingsConfigProps } from './StudioPanelPageSettings';
import { StudioLayoutPanelPagesConfigProps } from './StudioPanelPages';
import { StudioLayoutPanelPagesLayersConfigProps } from './StudioPanelPagesLayers';
import { StudioLayoutPanelPropertiesConfigProps } from './StudioPanelProperties';
import { StudioLayoutPanelSelectorsConfigProps } from './StudioPanelSelectors';
import { StudioLayoutPanelSidebarTabsConfigProps } from './StudioPanelSidebarTabs';
import { StudioLayoutPanelStylesConfigProps } from './StudioPanelStyles';
import { StudioLayoutPanelTemplatesConfigProps } from './StudioPanelTemplates';
import { StudioLayoutRowConfigProps } from './StudioRow';
import { StudioLayoutSelectFieldConfigProps } from './StudioSelectField';
import { StudioLayoutSelectFontFieldConfigProps } from './StudioSelectFontField';
import { StudioLayoutSidebarBottomConfigProps } from './StudioSidebarBottom';
import { StudioLayoutSidebarLeftConfigProps } from './StudioSidebarLeft';
import { StudioLayoutSidebarRightConfigProps } from './StudioSidebarRight';
import { StudioLayoutSidebarTopConfigProps } from './StudioSidebarTop';
import { StudioLayoutTabsConfigProps } from './StudioTabs';
import { StudioLayoutTextConfigProps } from './StudioText';
import { StudioLayoutVirtualListConfigProps } from './StudioVirtualList';
import { StudioLayoutPanelPropsConfig } from './types/StudioPanelSchema';
import { StudioLayouts } from './types/index';
export interface WithEditorState<T extends ObjectAny> {
    editor: Editor;
    state: T;
    setState: (props: Partial<T>) => void;
}
export interface WithEditorEvents<T extends ObjectAny> {
    editorEvents?: Record<string, (props: {
        fromEvent: ObjectAny;
    } & WithEditorState<T>) => void>;
}
export interface StudioBaseReactProps<T = HTMLElement> {
    style?: CSSProperties;
    children?: React.ReactNode;
    htmlAttrs?: React.HTMLProps<T>;
}
export type CommonStudioLayoutProps<T, K = HTMLElement> = Omit<T, 'type' | 'style' | 'children' | 'htmlAttrs'> & StudioBaseReactProps<K>;
export type CommonStudioLayoutFieldStateKeys = 'className' | 'style' | 'label' | 'name' | 'value' | 'size' | 'disabled' | 'required' | 'readOnly';
export type CommonStudioLayoutFieldProps<T, CH extends ObjectAny, K = HTMLElement> = Omit<CommonStudioLayoutProps<T, K>, 'label' | 'onChange' | 'editorEvents' | 'children'> & {
    label?: React.ReactNode;
    onChange?(props: CH): void;
};
export type CommonStudioLayoutPanelProps<T, K = HTMLElement> = CommonStudioLayoutProps<Omit<T, 'header' | 'resizable'> & StudioLayoutPanelPropsConfig, K>;
export type CommonStudioLayoutConfigProps<T, K extends {
    type: keyof typeof StudioLayouts;
}> = Omit<T, 'children'> & Pick<K, 'type'>;
export type CustomLayoutComponent = Required<StudioCustomLayoutProps>['component'];
export interface StudioLayoutWithChildrenConfigProps {
    children?: StudioLayoutChildrenConfigProps;
}
export type StudioLayoutChildrenConfigProps = StudioLayoutComponentsConfig | (StudioLayoutComponentsConfig | undefined | null | false)[];
export type StudioLayoutComponentsConfigProps = StudioLayoutCustomConfigProps | StudioLayoutRowConfigProps | StudioLayoutColumnConfigProps | StudioLayoutTextConfigProps | StudioLayoutButtonConfigProps | StudioLayoutButtonGroupFieldConfigProps | StudioLayoutInputFieldConfigProps | StudioLayoutCodeFieldConfigProps | StudioLayoutSelectFieldConfigProps | StudioLayoutSelectFontFieldConfigProps | StudioLayoutTabsConfigProps | StudioLayoutCanvasConfigProps | StudioLayoutDevicesConfigProps | StudioLayoutPanelLayersConfigProps | StudioLayoutPanelPagesConfigProps | StudioLayoutPanelSelectorsConfigProps | StudioLayoutPanelStylesConfigProps | StudioLayoutPanelPropertiesConfigProps | StudioLayoutPanelSidebarTabsConfigProps | StudioLayoutPanelPagesLayersConfigProps | StudioLayoutSidebarTopConfigProps | StudioLayoutSidebarBottomConfigProps | StudioLayoutCanvasSidebarTopConfigProps | StudioLayoutPanelBlocksConfigProps | StudioLayoutPanelAssetsConfigProps | StudioLayoutPanelTemplatesConfigProps | StudioLayoutPanelPageSettingsConfigProps | StudioLayoutPanelGlobalStylesConfigProps | StudioLayoutSidebarLeftConfigProps | StudioLayoutSidebarRightConfigProps | StudioLayoutVirtualListConfigProps | StudioLayoutDataPathFieldConfigProps | StudioLayoutDataVariablePickerConfigProps | StudioLayoutDataConditionPickerConfigProps | StudioLayoutDataCollectionPickerConfigProps;
export type StudioLayoutComponentsConfig = string | StudioLayoutComponentsConfigProps;
