export interface StudioLayoutBasePropsConfig {
    /**
     * The unique identifier for the component.
     * @example "component-123"
     */
    id?: string;
    /**
     * The CSS class name(s) for the component.
     * @example "my-component-class"
     */
    className?: string;
    /**
     * The inline styles for the component.
     * @example { color: "red", fontSize: "14px" }
     */
    style?: object;
    /**
     * The children layout components.
     * @example [{ type: "text", content: "Hello, World!" }]
     */
    children?: unknown;
    /**
     * The HTML attributes for the component.
     * @example { "data-test-id": "component-123" }
     */
    htmlAttrs?: object;
    /**
     * The HTML tag to use for the layout component.
     * @example "div"
     */
    as?: string;
}
export interface StudioLayoutFlexConfig extends StudioLayoutBasePropsConfig {
    /**
     * The height of the component.
     * @example 100
     */
    height?: string | number;
    /**
     * The width of the component.
     * @example 100
     */
    width?: string | number;
    /**
     * If true, the component will grow to fill available space.
     * @default false
     */
    grow?: boolean;
    /**
     * The gap between inner components.
     * @example 10
     */
    gap?: number;
    /**
     * If true, the component will take up the full available space.
     * @default false
     */
    full?: boolean;
    /**
     * The alignment of inner components along the cross axis.
     * @examples "start" | "end" | "center" | "baseline" | "stretch"
     */
    alignItems?: 'start' | 'end' | 'center' | 'baseline' | 'stretch';
    /**
     * The alignment of inner components along the main axis.
     * @examples "start" | "end" | "center" | "between" | "around" | "evenly"
     */
    justifyContent?: 'start' | 'end' | 'center' | 'between' | 'around' | 'evenly';
}
export interface StudioLayoutFieldBaseConfig extends Pick<StudioLayoutBasePropsConfig, 'className' | 'style' | 'id'> {
    /**
     * The name attribute for the field.
     * @example "username"
     */
    name?: string;
    /**
     * The label for the field.
     * @example "Username"
     */
    label?: string;
    /**
     * The value of the field.
     * @example "username"
     */
    value: string;
    /**
     * Indicates whether the field is required.
     * @default false
     */
    required?: boolean;
    /**
     * Indicates whether the field is disabled.
     * @default false
     */
    disabled?: boolean;
    /**
     * The function to call when the field value changes.
     * @examples ({ value, setState }) => setState({ value });
     */
    onChange?: '__fn__';
    /**
     * Update layout component state based on editor events.
     * @examples { 'component:selected': ({ setState, editor }) => setState({ className: 'custom-cls-' + editor.getSelected().getId() }) }
     */
    editorEvents?: object;
}
