import { StudioLayouts } from '.';
import type { StudioLayoutBasePropsConfig } from './StudioBaseSchema';
export interface StudioLayoutButtonConfig extends Omit<StudioLayoutBasePropsConfig, 'htmlAttrs'> {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.button}`;
    /**
     * Icon to be displayed in the button.
     * @example "close"
     */
    icon?: string;
    /**
     * Label for the button, can be a ReactNode or a function returning a ReactNode.
     * @example "Button"
     */
    label?: string;
    /**
     * Size of the button.
     * @examples "xs" | "s" | "m" | "lg"
     */
    size?: `${StudioButtonSize}`;
    /**
     * Variant of the button style.
     * @examples "primary" | "outline" | "shallow"
     */
    variant?: `${StudioButtonVariant}`;
    /**
     * Tooltip text for the button.
     * @example "Click to submit"
     */
    tooltip?: string;
    /**
     * HTML button type attribute.
     * @examples "button" | "submit" | "reset"
     */
    buttonType?: HTMLButtonElement['type'];
    /**
     * Indicates if the button is active.
     * @default false
     */
    active?: boolean;
    /**
     * Indicates whether the component is disabled.
     * @default false
     */
    disabled?: boolean;
    /**
     * Events to be handled by the editor.
     * @examples { 'component:add': ({ editor }) => { console.log('Component added'); } }
     */
    editorEvents?: object;
    /**
     * Click event handler for the button.
     * @examples ({ event }) => { alert('Button clicked!'); }
     */
    onClick?: '__fn__';
}
export declare enum StudioButtonVariant {
    primary = "primary",
    outline = "outline",
    shallow = "shallow"
}
export declare enum StudioButtonSize {
    none = "",
    xs = "xs",
    s = "s",
    m = "m",
    lg = "lg"
}
