import { StudioLayouts } from '.';
import { InputSize } from '../../InputField';
import type { StudioLayoutFieldBaseConfig } from './StudioBaseSchema';
export interface StudioLayoutCodeFieldConfig extends StudioLayoutFieldBaseConfig {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.codeField}`;
    /**
     * Indicates the language of the code field.
     * @example "json"
     */
    language: string;
    /**
     * The size of the field.
     * @examples "m" | "s"
     */
    size?: `${InputSize}`;
    /**
     * Indicates whether the field is read-only.
     * @default false
     */
    readOnly?: boolean;
    /**
     * Indicates the minimum height of the field.
     * @default "170px"
     */
    minHeight?: string;
    /**
     * Indicates if the field should be rendered in a row layout.
     * @default false
     */
    row?: boolean;
    /**
     * Pass additional options to the Monaco editor.
     * Docs: https://microsoft.github.io/monaco-editor/typedoc/interfaces/editor.IStandaloneEditorConstructionOptions.html
     * @default {}
     */
    monacoOptions?: object;
}
