import { StudioLayouts } from '.';
import type { StudioLayoutFieldBaseConfig } from './StudioBaseSchema';
export declare enum InputSize {
    m = "m",
    s = "s"
}
export type InputSizeType = `${InputSize}` | InputSize;
export interface StudioLayoutInputFieldConfig extends StudioLayoutFieldBaseConfig {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.inputField}`;
    /**
     * The type of the field.
     * @example "text"
     */
    inputType?: string;
    /**
     * The size of the field.
     * @examples "m" | "s"
     */
    size?: `${InputSize}`;
    /**
     * The placeholder text for the field.
     * @example "Enter your username"
     */
    placeholder?: string;
    /**
     * Indicates whether the field is read-only.
     * @default false
     */
    readOnly?: boolean;
    /**
     * Indicates if the field should be rendered in a row layout.
     * @default false
     */
    row?: boolean;
    /**
     * The function to call when the field value changes on input.
     * @examples ({ value, setState }) => setState({ value });
     */
    onInput?: '__fn__';
}
