/// <reference types="react" />
import type { StudioLayoutBasePropsConfig } from './StudioBaseSchema';
export interface StudioLayoutPanelConfig extends Omit<StudioLayoutPanelPropsConfig, 'header' | 'resizable'> {
    /**
     * Header of the panel.
     * @example { label: 'My label', collapsible: false }
     */
    header?: object;
    /**
     * Resizable configuration of the panel.
     * @example { width: 100, height: 300 }
     */
    resizable?: object;
}
export interface StudioLayoutPanelPropsConfig extends Omit<StudioLayoutBasePropsConfig, 'children'> {
    /**
     * Header of the panel.
     * @example { label: 'My label', collapsible: false }
     */
    header?: StudioPanelHeaderProps | boolean;
    /**
     * Resizable configuration of the panel.
     * @example { width: 100, height: 300 }
     */
    resizable?: StudioPanelResizableProps | boolean;
}
export interface StudioPanelResizableProps {
    top?: boolean;
    right?: boolean;
    bottom?: boolean;
    left?: boolean;
    width?: string | number;
    height?: string | number;
    minWidth?: string | number;
    minHeight?: string | number;
    maxWidth?: string | number;
    maxHeight?: string | number;
}
export interface StudioPanelHeaderProps {
    label?: string;
    collapsible?: boolean;
    collapsed?: boolean;
    commandItems?: any[];
    icon?: string;
    style?: React.CSSProperties;
    className?: string;
}
