import { StudioLayouts } from './index';
import type { StudioLayoutBasePropsConfig } from './StudioBaseSchema';
export interface StudioLayoutVirtualListConfig extends Pick<StudioLayoutBasePropsConfig, 'id' | 'style' | 'className'> {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.virtualList}`;
    /**
     * The items to be displayed in the virtual list.
     * @example [{ id: '1', name: 'Item 1' }, { id: '2', name: 'Item 2' }]
     */
    items: Record<string, any>[];
    /**
     * The layout component for the items in the virtual list.
     * @examples ({ item, editor }) => ({ type: 'row', children: item.name })
     */
    itemLayout?: '__fn__';
    /**
     * The number of items per row.
     * @default 12
     */
    itemsPerRow?: number;
}
