import type { ApiResponse } from '@studio/app/src/modules/utils/shared';
import type { Editor, ProjectData } from 'grapesjs';
interface PutProjectProps {
    licenseKey: string;
    projectId: string;
    fileMetadata: Pick<File, 'size'>;
    identityId: string;
    name: string;
    description: string;
}
export declare const putProjectAndGetUploadUrl: ({ licenseKey, projectId, ...body }: PutProjectProps) => Promise<{
    uploadUrl: string;
} | undefined>;
export declare const uploadToProjectCloud: (project: ProjectData, licenseKey: string, projectId: string, identityId: string) => Promise<void>;
export declare const getProjectDownloadUrl: (licenseKey: string, projectId: string, identityId: string) => Promise<ApiResponse<{
    downloadUrl: string;
}, {
    notFoundInDb: boolean;
}> | undefined>;
export declare const downloadFromProjectCloud: (editor: Editor, licenseKey: string, projectId: string, identityId: string) => Promise<{
    id: string;
    project: ProjectData;
}>;
export {};
