import type { Editor } from 'grapesjs';
import { DataVariableResolverProps } from '../../../components/DataVariablePicker';
export declare enum DataComponentTypes {
    variable = "data-variable",
    condition = "data-condition",
    conditionTrue = "data-condition-true-content",
    conditionFalse = "data-condition-false-content",
    collection = "data-collection",
    collectionItem = "data-collection-item"
}
export declare function isDataVariable(value: any): value is DataVariableResolverProps;
export declare function resolveString(value: string | DataVariableResolverProps): string;
export declare function getDataVariableDisplayString(path: string): string;
export declare function stringify(value: any): string;
export declare function getDataSourcePaths(editor: Editor): Record<string, any>;
export declare function transformGlobalDataSourceObject(input: any): {
    id: string;
    data: unknown;
}[] | undefined;
