import type { DataVariableResolverProps } from '../../../components/DataVariablePicker';
import type { DataCollectionResolverProps } from '../../../components/public/types/StudioDataCollectionPickerSchema';
import type { ToHTMLOptions } from 'grapesjs';
import type { Exporter } from './Exporter';
import type { GetCustomPath } from '../../../typeConfigs/dataSources';
export interface ITemplateStrategy {
    getHelperId(operator: string, typeHint?: 'string' | 'number' | 'any'): string | undefined;
    getVariableSyntax(options: DataVariableResolverProps): string;
    getCollectionStartSyntax(options: DataCollectionResolverProps): string;
    getCollectionEndSyntax(): string;
    getConditionalStartSyntax(condition: any): string;
    getConditionElseSyntax(): string;
    getConditionalEndSyntax(): string;
}
export type TemplatingExportOptions = ToHTMLOptions & {
    exporter: Exporter;
    getCustomPath?: GetCustomPath;
};
