import { ExportConfig } from '../../typeConfigs/dataSources';
import { ITemplateStrategy } from './templateEngines/types';
export declare enum StudioCommands {
    /**
     * Add a new toast.
     * @example
     * editor.runCommand(StudioCommands.toastAdd, {
     *  id: 'toast-test',
     *  header: <div>Toast header</div>,
     *  content: <div>Toast content</div>,
     *  variant: ToastVariant.Warning,
     * });
     */
    toastAdd = "studio:toastAdd",
    /**
     * Open dialog.
     * @example
     * editor.runCommand(StudioCommands.dialogOpen, {
     *  title: <div>Dialog header</div>,
     *  content: <div>Dialog content</div>,
     * });
     */
    dialogOpen = "studio:dialogOpen",
    /**
     * Close dialog.
     * @example
     * editor.runCommand(StudioCommands.dialogClose);
     */
    dialogClose = "studio:dialogClose",
    /**
     * Update left sidebar state.
     * @example
     * editor.runCommand(StudioCommands.sidebarLeftSet, { visible: false });
     */
    sidebarLeftSet = "studio:sidebarLeft:set",
    /**
     * Get left sidebar state.
     * @example
     * const state = editor.runCommand(StudioCommands.sidebarLeftGet);
     */
    sidebarLeftGet = "studio:sidebarLeft:get",
    /**
     * Toggle left sidebar visibility.
     * @example
     * editor.runCommand(StudioCommands.sidebarLeftToggle);
     */
    sidebarLeftToggle = "studio:sidebarLeft:toggle",
    /**
     * Update right sidebar state.
     * @example
     * editor.runCommand(StudioCommands.sidebarRightSet, { visible: false });
     */
    sidebarRightSet = "studio:sidebarRight:set",
    /**
     * Get right sidebar state.
     * @example
     * const state = editor.runCommand(StudioCommands.sidebarRightGet);
     */
    sidebarRightGet = "studio:sidebarRight:get",
    /**
     * Toggle right sidebar visibility.
     * @example
     * editor.runCommand(StudioCommands.sidebarRightToggle);
     */
    sidebarRightToggle = "studio:sidebarRight:toggle",
    /**
     * Update top sidebar state.
     * @example
     * editor.runCommand(StudioCommands.sidebarTopSet, { visible: false });
     */
    sidebarTopSet = "studio:sidebarTop:set",
    /**
     * Get top sidebar state.
     * @example
     * const state = editor.runCommand(StudioCommands.sidebarTopGet);
     */
    sidebarTopGet = "studio:sidebarTop:get",
    /**
     * Toggle top sidebar visibility.
     * @example
     * editor.runCommand(StudioCommands.sidebarTopToggle);
     */
    sidebarTopToggle = "studio:sidebarTop:toggle",
    /**
     * Update bottom sidebar state.
     * @example
     * editor.runCommand(StudioCommands.sidebarBottomSet, { visible: false });
     */
    sidebarBottomSet = "studio:sidebarBottom:set",
    /**
     * Get bottom sidebar state.
     * @example
     * const state = editor.runCommand(StudioCommands.sidebarBottomGet);
     */
    sidebarBottomGet = "studio:sidebarBottom:get",
    /**
     * Toggle bottom sidebar visibility.
     * @example
     * editor.runCommand(StudioCommands.sidebarBottomToggle);
     */
    sidebarBottomToggle = "studio:sidebarBottom:toggle",
    /**
     * Add new symbol.
     * @example
     * editor.runCommand(StudioCommands.symbolAdd, { component: editor.getSelected() });
     */
    symbolAdd = "studio:symbolAdd",
    /**
     * Detach symbol.
     * @example
     * editor.runCommand(StudioCommands.symbolDetach, { component: editor.getSelected() });
     */
    symbolDetach = "studio:symbolDetach",
    /**
     * Set symbol override
     * @example
     * editor.runCommand(StudioCommands.symbolOverride, { component: editor.getSelected(), override: true });
     */
    symbolOverride = "studio:symbolOverride",
    symbolPropagateStyles = "studio:propagateStyles",
    /**
     * Get current Pages config.
     * @example
     * const config: PagesConfig = editor.runCommand(StudioCommands.getPagesConfig);
     */
    getPagesConfig = "studio:getPagesConfig",
    /**
     * Update Pages config.
     * @example
     * const config: PagesConfig = { add: false };
     * editor.runCommand(StudioCommands.setPagesConfig, { config });
     */
    setPagesConfig = "studio:setPagesConfig",
    /**
     * Get page settings panel state.
     * @example
     * const state: PanelPageSettingsState = editor.runCommand(StudioCommands.getPageSettings);
     */
    getPageSettings = "studio:getPageSettings",
    /**
     * Update page settings panel state.
     * @example
     * editor.runCommand(StudioCommands.setPageSettings, { isOpen: true });
     */
    setPageSettings = "studio:setPageSettings",
    /**
     * Get an array of project files.
     * @example
     * const files: ProjectFile[] = await editor.runCommand(StudioCommands.projectFiles);
     */
    projectFiles = "studio:projectFiles",
    /**
     * Reload canvas.
     * @example
     * editor.runCommand(StudioCommands.canvasReload);
     */
    canvasReload = "studio:canvasReload",
    /**
     * Get blocks panel state.
     * @example
     * const state = editor.runCommand(StudioCommands.getBlocksPanel);
     */
    getBlocksPanel = "studio:getBlocksPanel",
    /**
     * Update blocks panel state.
     * @example
     * editor.runCommand(StudioCommands.setBlocksPanel, { isOpen: true });
     */
    setBlocksPanel = "studio:setBlocksPanel",
    /**
     * Get context menu state.
     * @example
     * editor.runCommand(StudioCommands.getStateContextMenu);
     */
    getStateContextMenu = "studio:getStateContextMenu",
    /**
     * Update context menu state.
     * @example
     * editor.runCommand(StudioCommands.setStateContextMenu, { enabled: false });
     */
    setStateContextMenu = "studio:setStateContextMenu",
    /**
     * Show context menu for a component.
     * @example
     * editor.runCommand(StudioCommands.contextMenuComponent, { component: editor.getSelected(), x: 0, y: 0 });
     */
    contextMenuComponent = "studio:contextMenuComponent",
    /**
     * Add a new layout panel.
     * @example
     * editor.runCommand(StudioCommands.layoutAdd, { id: 'pagesLayers', type: 'panelPagesLayers', });
     */
    layoutAdd = "studio:layoutAdd",
    /**
     * Remove layout panel.
     * @example
     * editor.runCommand(StudioCommands.layoutRemove, { id: 'pagesLayers' });
     */
    layoutRemove = "studio:layoutRemove",
    /**
     * Toggle layout panel.
     * @example
     * editor.runCommand(StudioCommands.layoutToggle, { id: 'pagesLayers', ... });
     */
    layoutToggle = "studio:layoutToggle",
    /**
     * Update existing layout panel.
     * @example
     * editor.runCommand(StudioCommands.layoutUpdate, { id: 'pagesLayers', ... });
     */
    layoutUpdate = "studio:layoutUpdate",
    /**
     * Get existing layout panel.
     * @example
     * editor.runCommand(StudioCommands.layoutGet, { id: 'pagesLayers' });
     */
    layoutGet = "studio:layoutGet",
    /**
     * Get current layout config.
     * @example
     * editor.runCommand(StudioCommands.layoutConfigGet);
     */
    layoutConfigGet = "studio:layoutConfigGet",
    /**
     * Update layout config.
     * @example
     * editor.runCommand(StudioCommands.layoutConfigSet, { default: {...} });
     */
    layoutConfigSet = "studio:layoutConfigSet",
    /**
     * Get theme state.
     * @example
     * editor.runCommand(StudioCommands.getStateTheme);
     */
    getStateTheme = "studio:getStateTheme",
    /**
     * Update theme state.
     * @example
     * editor.runCommand(StudioCommands.setStateTheme, { theme: 'light' });
     */
    setStateTheme = "studio:setStateTheme",
    /**
     * Get list of asset providers.
     * @example
     * editor.runCommand(StudioCommands.assetProviderGet);
     */
    assetProviderGet = "studio:assetProviderGet",
    /**
     * Add an asset provider. If a provider with the same id already exists, it is removed after inserting the new one.
     * @example
     * // add at the start
     * editor.runCommand(StudioCommands.assetProviderAdd, { provider: { id: 'myProviderId', ... }, index: 0 });
     */
    assetProviderAdd = "studio:assetProviderAdd",
    /**
     * Remove an asset provider.
     * @example
     * editor.runCommand(StudioCommands.assetProviderRemove, { id: 'myProviderId' });
     */
    assetProviderRemove = "studio:assetProviderRemove",
    /**
     * Get font map.
     *
     * @example
     * editor.runCommand(StudioCommands.fontGet);
     */
    fontGet = "studio:fontGet",
    /**
     * Add font.
     *
     * @example
     * editor.runCommand(StudioCommands.fontAdd, { font: myFont });
     */
    fontAdd = "studio:fontAdd",
    /**
     * Remove font.
     *
     * @example
     * editor.runCommand(StudioCommands.fontRemove, { family: 'myFontFamily' });
     */
    fontRemove = "studio:fontRemove",
    /**
     * Open the font asset manager.
     *
     * @example
     * editor.runCommand(StudioCommands.fontManagerOpen, assetManagerProps)
     */
    fontManagerOpen = "studio:fontManagerOpen",
    /**
     * Load a menu font for display.
     * Useful when in font itemLayout.
     *
     * @example
     * const menuFontFamily = editor.runCommand(StudioCommands.menuFontLoad, { font });
     */
    menuFontLoad = "studio:menuFontLoad",
    /**
     * Toggle the view of data source components between the final UI and the raw value/condition.
     * When false, the component renders its final UI as it would appear in the exported version.
     * When true, the component displays its underlying data structure:
     * - For data variable components, it shows the path to the data variable.
     * - For Condition components, it shows the condition expression, as well as the content defined for both the true and false components.
     * @example
     * editor.runCommand(StudioCommands.toggleStateDataSource);
     */
    toggleStateDataSource = "studio:toggleStateDataSource",
    /**
     * Get the current state of the data source view. Returns true if the raw value/condition view is active, and false if the final UI view is active.
     * @example
     * const isRawViewActive: boolean = editor.runCommand(StudioCommands.getStateDataSource);
     */
    getStateDataSource = "studio:getStateDataSource",
    /**
     * Set the drag absolute state. Indicates whether the drag absolute mode is enabled or disabled.
     * @example
     * editor.runCommand(StudioCommands.setDragAbsolute, { enabled: true });
     */
    setDragAbsolute = "studio:setDragAbsolute"
}
export interface StudioCommandProjectFileOptions {
    /**
     * Export specific page. By default, all pages are exported.
     */
    page?: any;
    /**
     * If the HTML containes base64 images, they will be exported as separate files and placed in the specified folder name.
     * @default 'assets'
     */
    assetsFolder?: string;
    /**
     * Filename for CSS file.
     * @default 'style.css'
     */
    filenameCss?: string;
    /**
     * Indicate how to export styles. By default, styles are exported in a separate CSS file.
     * @example
     * 'inline' // Inline styles inside the HTML page
     * 'skip' // Skip page styles
     */
    styles?: 'inline' | 'skip';
    /**
     * Skip project file (project JSON)
     * @default false
     */
    skipProject?: boolean;
    /**
     * Configuration options for exporting data resolvers.
     * @default undefined
     */
    exportConfig?: ExportConfig & {
        exportStrategy?: ITemplateStrategy;
    };
}
export interface StudioCommandOptions {
    [StudioCommands.projectFiles]: StudioCommandProjectFileOptions;
}
export declare enum StudioEvents {
    layoutToggleId = "studio:layoutToggle:",
    toggleBlocksPanel = "studio:toggleBlocksPanel",
    pageSettingsUpdate = "studio:pageSettingsUpdate",
    toggleDataSourcesPreview = "studio:toggleDataSourcesPreview"
}
