import type { Component, Editor, Page, ToolbarButtonProps } from 'grapesjs';
export declare const isComponentType: (type: string) => (el: Element) => boolean;
export declare const toEditorType: (...ids: string[]) => string;
export declare const elHasTagName: (el: HTMLElement, ...tags: string[]) => boolean;
export declare const hasTagName: (el: HTMLElement, ...tags: string[]) => boolean;
export declare const elHasClassName: (el: HTMLElement, className: string) => boolean;
export declare const elHasAttribute: (el: HTMLElement, attrName: string) => boolean;
export declare const getBlockIndex: (editor: Editor, blockId: string) => number;
export declare const toSafeFilename: (value: string) => string;
export declare const getPageSlug: (editor: Editor, page: Page, ext?: string) => string;
export declare const addToolbarItem: (model: Component, item: ToolbarButtonProps & {
    id: string;
}) => void;
