import type { Component } from 'grapesjs';
import { Store } from '.';
import { ComponentContextMenuProps, ContextMenuItem } from '../typeConfigs/components';
export interface ContextMenuCoords {
    x: number;
    y: number;
    w?: number;
    h?: number;
    width?: number;
    height?: number;
}
export interface ContextMenuShowProps extends ContextMenuCoords {
    items: ContextMenuItem[];
}
export interface CommandContextMenuComponentOptions extends Omit<ComponentContextMenuProps, 'items' | 'editor' | 'type' | 'source'>, ContextMenuCoords {
    source?: ComponentContextMenuProps['source'];
    skipSelect?: boolean;
}
export declare class ContextMenuStore {
    store: Store;
    isOpen: boolean;
    isEnabled: boolean;
    items: ContextMenuItem[];
    coordinates: ContextMenuCoords;
    constructor(store: Store);
    get publicState(): {
        enabled: boolean;
    };
    setPublicState(state: Partial<ContextMenuStore['publicState']>): void;
    showForComponent(component: Component, opts: Omit<CommandContextMenuComponentOptions, 'component'>): Generator<import("mobx/dist/internal").CancellablePromise<ContextMenuItem[]>, void, ContextMenuItem[]>;
    getItemsForComponent: (component: Component, opts?: Pick<CommandContextMenuComponentOptions, "source" | "event"> | undefined) => import("mobx/dist/internal").CancellablePromise<ContextMenuItem[]>;
    show({ items, x, y, w, h }: ContextMenuShowProps): void;
    hide(): void;
    clear(): void;
}
export declare const useContextMenuStore: () => ContextMenuStore;
export declare const getContextMenuStore: () => ContextMenuStore;
