import { Store } from '.';
import { ProjectSourceConfig } from '../modules/templates';
import { ProjectConfigType } from '../types';
import { ProjectItem } from '../utils/types';
export declare class TemplatesStore {
    store: Store;
    _projectTypeFilter: ProjectConfigType;
    _projectSourceFilter: ProjectSourceConfig;
    _loadedProjects?: ProjectItem[];
    _loadedTemplates?: ProjectItem[];
    constructor(store: Store);
    get projectTypeFilter(): ProjectConfigType;
    get projectSourceFilter(): ProjectSourceConfig;
    get templates(): ProjectItem[] | undefined;
    get projects(): ProjectItem[] | undefined;
    get filteredTemplates(): ProjectItem[] | undefined;
    loadProjects(): Promise<void>;
    loadTemplates(): Promise<void>;
    loadAllTemplates(): Promise<void>;
    removeProject(id: string): Promise<void>;
    setProjectTypeFilter(projectType: ProjectConfigType): Promise<void>;
    setProjectSourceFilter(source: ProjectSourceConfig): void;
    setTemplates(templates?: ProjectItem[]): void;
    setProjects(projects?: ProjectItem[]): void;
}
export declare const useTemplatesStore: () => TemplatesStore;
export declare const getTemplatesStore: () => TemplatesStore;
