import type { ApiResponse, SdkLicensePublic, LicenseCheckResultBase } from '@studio/app/src/modules/utils/shared';
import type { Editor } from 'grapesjs';
import { InitialStoreState, Store } from '.';
import { AppProps } from '../App';
import { AssetProps, CreateEditorOptions, PanelPageSettingsState, ProjectConfigType } from '../types';
import { BeforeInstallPromptEvent, InstallablePlugin, ProjectData, ProjectDataCustom, ProjectItem } from '../utils/types';
type DisplayMode = 'browser' | 'standalone';
type DesignerTab = 'style' | 'props';
export declare class AppEditorStore {
    store: Store;
    projectType: ProjectConfigType;
    editor?: Editor;
    sdkProps: AppProps;
    sdkLicense?: SdkLicensePublic;
    sdkLicenseError: string;
    licenseCheckRetry: number;
    showPoweredBy: boolean;
    isInPreview: boolean;
    isCssPanelActive: boolean;
    isLeftSidebarOpen: boolean;
    isRightSidebarOpen: boolean;
    isTopSidebarOpen: boolean;
    isBottomSidebarOpen: boolean;
    isSelectingTarget: boolean;
    leftSidebarSize: number;
    rightSidebarSize: number;
    transitionTime: number;
    topBarSize: number;
    isDev: boolean;
    isStage: boolean;
    editorKey: number;
    appInstalled: boolean;
    licenseKey: string;
    licenseCheckStarted: boolean;
    studioSdkVersion: string | undefined;
    installEvent?: BeforeInstallPromptEvent;
    projectDataCustom: ProjectDataCustom;
    displayMode: DisplayMode;
    projectPlugins: InstallablePlugin[];
    queryParams: Record<string, string>;
    isCanvasPanning: boolean;
    selectedDesignerTab: DesignerTab;
    customAssets?: AssetProps[];
    nextProjectData?: ProjectData;
    isDraggingAbsolute: boolean;
    isSaving: boolean;
    isReady: boolean;
    sdkPagesConfigUpdates: number;
    panelPageSettings: PanelPageSettingsState;
    rootElWidth: number;
    _projectId: string;
    constructor(store: Store, initialState?: InitialStoreState<AppEditorStore>);
    get baseApiUrl(): string;
    get projectId(): string;
    get projectIdToLoad(): string;
    get currentProjectId(): string;
    get isBrowserMode(): boolean;
    get sdkOptions(): CreateEditorOptions;
    get sdkProjectId(): string | undefined;
    get sdkIdentityId(): string | undefined;
    get sdkPagesConfig(): false | import("../types").PagesConfig | undefined;
    get sdkLayoutConfig(): import("../types").LayoutConfig | undefined;
    get sdkComponentsConfig(): import("../types").ComponentsConfig | undefined;
    get currentLayout(): import("../types").RootLayoutConfig;
    get sdkCustomIcons(): Partial<import("../components/public/StudioIcon").Icons> | undefined;
    get isProjectTypeEmail(): boolean;
    get showPages(): boolean;
    get showSelectors(): boolean;
    get sdkMisconfigurationError(): "" | "SDK Misconfiguration Error: When using assets.storageType == \"cloud\" or storage.type === \"cloud\", project.id and identity.id are required.";
    get isUsingProjectSelfHosted(): boolean;
    get isUsingProjectCloud(): boolean;
    get publicStateTheme(): {
        theme: "dark" | "light" | "auto";
        resolvedTheme: "dark" | "light" | "auto";
    };
    setPublicStateTheme(state: Partial<AppEditorStore['publicStateTheme']>): void;
    init(): Generator<Promise<ProjectItem[]> | Generator<Promise<InstallablePlugin[]>, void, InstallablePlugin[]>, void, ProjectItem[]>;
    setInstallEvent(value?: BeforeInstallPromptEvent): void;
    setAppInstalled(value: boolean): void;
    setDisplayMode(value: DisplayMode): void;
    setProject(project: ProjectItem): void;
    setProjectDataCustom(data?: ProjectDataCustom): void;
    /**
     * Load new GrapesJS JSON (eg. from .grapesjs file)
     */
    loadProjectData(projectData: ProjectData): void;
    setNextProjectData(projectData?: ProjectData): void;
    setLeftSidebarSize(value: number): void;
    setRightSidebarSize(value: number): void;
    setEditor(value?: Editor): void;
    setPreview(value: boolean): void;
    toggleCssPanel(): void;
    toggleLeftSidebar(): void;
    setLeftSidebarOpen(value: boolean): void;
    toggleRightSidebar(): void;
    setRightSidebarOpen(value: boolean): void;
    setTopSidebarOpen(value: boolean): void;
    setBottomSidebarOpen(value: boolean): void;
    refreshEditorPostTransition(): void;
    setCanvasPanning(value: boolean): void;
    setSelectingTarget(value: boolean): void;
    setSelectedDesignerTab(value: DesignerTab): void;
    setCustomAssets(value: AssetProps[]): void;
    setIsDraggingAbsolute(value: boolean): void;
    setIsSaving(value: boolean): void;
    setIsReady(value: boolean): void;
    setPanelPageSettings(value: Partial<PanelPageSettingsState>): void;
    setSdkPagesConfig(value: CreateEditorOptions['pages']): void;
    setRootElWidth(value: number): void;
    loadLicense(): Generator<Promise<unknown>, void, ApiResponse<LicenseCheckResultBase, object>>;
    updateStudio(): Generator<Generator<Promise<InstallablePlugin[]>, void, InstallablePlugin[]>, void, unknown>;
    refreshStudio(): void;
    refreshEditorCanvas(): void;
}
export declare const subscribeToAppEditorStore: (store: AppEditorStore) => void;
export declare const useAppEditorStore: () => AppEditorStore;
export declare const useShallowAppEditorStore: () => AppEditorStore | undefined;
export declare const getAppEditorStore: () => AppEditorStore;
export declare const useTransitionEnd: () => number[];
export {};
