import React from 'react';
import { AssetsStore } from './AssetsStore';
import { ContextMenuStore } from './ContextMenuStore';
import { FontsStore } from './FontsStore';
import { I18nStore } from './I18nStore';
import { LayoutStore } from './LayoutStore';
import { PointerBadgeStore } from './PointerBadgeStore';
import { TemplatesStore } from './TemplatesStore';
import { ToastStore } from './ToastStore';
import { AppEditorStore } from './appEditorStore';
import { BlockManagerStore } from './blockManager';
import { GlobalStylesStore } from './globalStylesStore';
import { LocalSettingsStore } from './localSettings';
import { ModalStore } from './modalStore';
import { PluginStore } from './pluginStore';
type IfEquals<X, Y, A, B> = (<T>() => T extends X ? 1 : 2) extends <T>() => T extends Y ? 1 : 2 ? A : B;
type WritableKeysOf<T> = {
    [P in keyof T]: IfEquals<{
        [Q in P]: T[P];
    }, {
        -readonly [Q in P]: T[P];
    }, P, never>;
}[keyof T];
export type WritablePart<T> = Pick<T, WritableKeysOf<T>>;
export type InitialStoreState<T> = {
    [P in keyof T]?: Partial<T[P]>;
};
export type StoreProviderProps = {
    children: React.ReactNode;
    initialState?: InitialStoreState<Store>;
};
export declare class Store {
    localSettingsStore: LocalSettingsStore;
    appEditorStore: AppEditorStore;
    blockManagerStore: BlockManagerStore;
    globalStylesStore: GlobalStylesStore;
    modalStore: ModalStore;
    toastStore: ToastStore;
    i18nStore: I18nStore;
    pluginStore: PluginStore;
    pointerBadgeStore: PointerBadgeStore;
    contextMenu: ContextMenuStore;
    layoutStore: LayoutStore;
    templatesStore: TemplatesStore;
    assetsStore: AssetsStore;
    fontsStore: FontsStore;
    constructor(initialState?: InitialStoreState<Store>);
}
export declare const StoreProvider: ({ children, initialState }: StoreProviderProps) => import("react/jsx-runtime").JSX.Element;
export declare const useStore: () => Store;
export declare const getStore: () => Store;
export {};
