import { InitialStoreState } from '.';
import { UserLocalState } from '../utils/localState';
import { ProjectConfigType, ThemeOptions } from '../types';
export declare const clsDark = "gs-utl-dark";
export declare class LocalSettingsStore {
    key: string;
    theme: ThemeOptions;
    resolvedTheme: ThemeOptions;
    lastProjectId: string;
    lastProjectType?: ProjectConfigType;
    updateAppShell: boolean;
    rootEl?: HTMLElement;
    constructor(initialState?: InitialStoreState<LocalSettingsStore>);
    init(): void;
    changeTheme(theme: ThemeOptions): void;
    setTheme(value: ThemeOptions): void;
    setRootEl(rootEl: HTMLElement): void;
    setLocalState(localState: Partial<UserLocalState>): void;
    get isDarkTheme(): boolean;
}
export declare const subscribeToLocalSettingsStore: (localSettingsStore: LocalSettingsStore) => void;
export declare const useLocalSettingsStore: () => LocalSettingsStore;
