/// <reference types="react" />
import { Store } from '.';
import { ButtonProps } from '../components/Button';
import { ModalProps } from '../components/Modal';
import { ValidReactNode } from '../utils/types';
type ModalPropsWithContent = Partial<ModalProps & {
    content: ValidReactNode;
}>;
interface ModalConfirmProps extends ModalPropsWithContent {
    onConfirm: () => void;
    confirmButton?: Partial<ButtonProps>;
}
export interface DialogOptions extends Pick<ModalPropsWithContent, 'title' | 'content' | 'closable' | 'onClose' | 'size'> {
}
export declare class ModalStore {
    store: Store;
    isOpen: boolean;
    title: React.ReactNode;
    content: ValidReactNode;
    size: ModalProps['size'];
    fullH: ModalProps['fullH'];
    modalProps: Partial<ModalProps>;
    buttons: ButtonProps[];
    constructor(store: Store);
    setModalProps(props: Partial<ModalProps>): void;
    open({ content, ...rest }: ModalPropsWithContent): void;
    close(): void;
    clear(): void;
    confirm({ content, size, onConfirm, confirmButton, ...rest }: ModalConfirmProps): void;
}
export declare const useModalStore: () => ModalStore;
export {};
