import { Store } from '.';
import { InstallablePlugin } from '../utils/types';
import { EditorPluginsToLoad, ProjectConfigType } from '../types';
import { AppEditorStore } from './appEditorStore';
export declare class PluginStore {
    store: Store;
    projectPlugins: InstallablePlugin[] | undefined;
    loadCounter: number;
    pendingInstalled: string[];
    pendingUninstalled: string[];
    selectedShown: boolean;
    constructor(store: Store);
    get hasPending(): boolean;
    initProjectPlugins(projectType: ProjectConfigType): Generator<Promise<InstallablePlugin[]>, void, InstallablePlugin[]>;
    getPluginsToLoad(projectType: ProjectConfigType, appStore: AppEditorStore): EditorPluginsToLoad;
    addPendingInstalled(plugin: InstallablePlugin): void;
    addPendingUninstalled(plugin: InstallablePlugin): void;
    setSelectedShown(value: boolean): void;
}
export declare const loadInstalledPlugins: () => Promise<InstallablePlugin[]>;
export declare const installPlugin: (plugin: InstallablePlugin) => Promise<void>;
export declare const uninstallPlugin: (plugin: InstallablePlugin) => Promise<void>;
export declare const usePluginStore: () => PluginStore;
export declare const getPluginStore: () => PluginStore;
