import { Font, FontFaceArgs, FontWithFamily, InternalFont, InternalFontFaceArgs } from '../typeConfigs/shared';
export declare const toInternalFontFamily: (family: string) => string;
export declare const toInternalFontFaceArgs: (family: string, variant: string, args: FontFaceArgs) => InternalFontFaceArgs;
export declare const toInternalFont: (family: string, font: Font) => InternalFont;
/**
 * Loads a font variant for display in font lists.
 * This doesn't wait for the font to load.
 * @returns font family of this menu variant.
 */
export declare const loadMenuFont: (font: FontWithFamily, skipLoad?: boolean) => string;
