import type { Component, ObjectAny } from 'grapesjs';
export type GetCustomPath = (opts: {
    component: Component;
    path: string;
    paths: string[];
}) => string;
export interface ExportConfig {
    getCustomPath?: GetCustomPath;
}
export interface DataSourcesConfig {
    /**
     * Configuration for global datasets that can be used as data sources.
     */
    globalData?: GlobalDataset;
    /**
     * Add data source components to blocks.
     * @default false
     */
    blocks?: boolean;
    /**
     * Configuration options for exporting data resolvers.
     */
    exportConfig?: ExportConfig;
}
/**
 * Represents the global datasets available as data sources.
 * For example:
 * ```
 * {
 * user: { firstname: 'John', lastname: 'Doe', age: 30 },
 * products: [{ name: 'Laptop', price: 1200 }, { name: 'Mouse', price: 25 }]
 * }
 * ```
 * Each key in this record represents the name of a global dataset (e.g., 'user', 'products').
 * The value associated with each key can be either a single object or an array of objects, representing the data for that dataset.
 */
export type GlobalDataset = Record<string, ObjectAny | ObjectAny[]>;
