import type { Options } from '@popperjs/core';
import { CSSProperties } from 'react';
import { StudioIconProps } from '../components/public/StudioIcon';
import { ContextMenuCoords } from '../store/ContextMenuStore';
import { StudioLayoutColumnConfigProps, StudioLayoutRowConfigProps, StudioLayoutComponentsConfigProps } from './layoutComponents';
export type RootLayoutConfig = StudioLayoutRowConfigProps | StudioLayoutColumnConfigProps;
export type ResponsiveLayoutConfig = Record<string, RootLayoutConfig>;
export interface LayoutConfig {
    default?: RootLayoutConfig;
    responsive?: ResponsiveLayoutConfig;
}
export declare enum LayoutPosition {
    left = "left",
    right = "right",
    top = "top",
    bottom = "bottom"
}
export interface LayoutHeader extends Pick<StudioIconProps, 'icon'> {
    label?: string;
    className?: string;
    close?: boolean;
    style?: React.CSSProperties;
}
export declare enum LayoutPlacers {
    popover = "popover",
    absolute = "absolute",
    static = "static",
    dialog = "dialog"
}
export interface LayoutPlacerAbsolute {
    type: `${LayoutPlacers.absolute}`;
    position: LayoutPosition | `${LayoutPosition}`;
}
export interface LayoutPlacerPopover extends ContextMenuCoords {
    type: `${LayoutPlacers.popover}`;
    options?: Partial<Options>;
    closeOnClickAway?: boolean;
}
export interface LayoutPlacerStatic {
    type: `${LayoutPlacers.static}`;
    layoutId: string;
    skipCleanup?: boolean;
}
export interface LayoutPlacerDialog {
    type: `${LayoutPlacers.dialog}`;
    title?: string;
    size?: 'l' | 'm' | 's';
}
export interface LayoutCommandProps {
    id: string;
    layout: StudioLayoutComponentsConfigProps['type'] | StudioLayoutComponentsConfigProps;
    disablePropagation?: boolean;
    placer?: LayoutPlacerAbsolute | LayoutPlacerPopover | LayoutPlacerStatic | LayoutPlacerDialog;
    props?: Record<string, any>;
    className?: string;
    header?: LayoutHeader | false;
    style?: CSSProperties;
    full?: boolean;
    toRemove?: boolean;
}
