import { ProjectData, ProjectType } from '../utils/types';
export { ProjectType } from '../utils/types';
export type { ProjectData } from '../utils/types';
export type ProjectConfigType = ProjectType | `${ProjectType}`;
export interface ProjectFile {
    path?: string;
    filename: string;
    content: string | Blob;
    mimeType: string;
}
export interface ProjectConfig {
    default?: ProjectData;
    /**
     * Specify the type of the project.
     * @default 'web'
     */
    type?: ProjectConfigType;
    /**
     * A unique id for the project.
     * Mandatory for project/asset cloud.
     * Avoid easy to guess, public identifiers or sensitive data here, like emails.
     */
    id?: string;
    types?: boolean;
}
